# CEDAR C++ SDK Example (Ready to Compile)

This project is a production-oriented C++ wrapper for your CEDAR auth backend.

It includes advanced workflow methods:

- `bootstrap_channel()`
- `authenticate_identity()`
- `enroll_identity()`
- `activate_entitlement()`
- `attest_session()`
- `dispatch_telemetry()`
- `fetch_module()`

Compatibility aliases are also present:
`init/login/regstr/license/check/log/download`.

## What it ships with

- HTTP client (libcurl)
- HMAC request signing for SDK init/license calls
- JSON response field parsing helpers
- Automatic session token storage (SDK + auth)
- HWID retrieval helper
- Secure string type with memory wipe on destruction
- AES-256-GCM encrypt/decrypt utility
- Defensive runtime checks:
  - debugger detection
  - VM heuristics
  - process blacklist scanning
  - executable integrity hash helper

## Files

- `include/cedar_client.hpp`
- `src/cedar_client.cpp`
- `src/main.cpp`
- `docs/SECURITY.md`
- `CMakeLists.txt`

## Build

```bash
cd /home/admin/license_cloud_auth/cedar_cpp_client
cmake -S . -B build
cmake --build build -j
./build/cedar_client
```

## Use As Library

Build/install:

```bash
cd /home/admin/license_cloud_auth/cedar_cpp_client
cmake -S . -B build -DCMAKE_INSTALL_PREFIX=/usr/local
cmake --build build -j
cmake --install build
```

Use from another CMake project:

```cmake
find_package(cedar_sdk CONFIG REQUIRED)
target_link_libraries(your_app PRIVATE cedar::sdk)
```

Or vendor directly:

```cmake
add_subdirectory(path/to/cedar_cpp_client)
target_link_libraries(your_app PRIVATE cedar_sdk)
```

## Method-to-endpoint mapping

- `bootstrap_channel()` -> `POST /api/sdk/init`
- `authenticate_identity()` -> `POST /api/auth/login`
- `enroll_identity()` -> `POST /api/auth/register`
- `activate_entitlement()` -> `POST /api/sdk/license/activate`
- `attest_session()` -> `POST /api/sdk/heartbeat` + `GET /api/sdk/license/validate`
- `dispatch_telemetry()` -> `POST /api/sdk/log` (requires active SDK session token)
- `fetch_module()` -> `GET <path-or-url>` (uses SDK bearer token if present)

## Important notes

- `owner_id` in this sample is sent as `app_id` to `/api/sdk/init`.
- `download()` is generic because your backend currently has no dedicated SDK file-download route.
- Example telemetry logging is opt-in (`CEDAR_EXAMPLE_EMIT_LOG=1`) to avoid noisy admin queues during normal login testing.
- Client-side protections are defense-in-depth only; final enforcement must stay server-side.

## Extra Security Controls In `ClientConfig`

- `tls_pinned_public_key`: curl public-key pin support.
- `expected_server_signing_key_b64`: pin backend signing key from sdk init response.
- `max_clock_skew_secs`: reject large server/client clock drift.
- `block_if_debugger_detected`
- `block_if_vm_detected`
- `block_if_blacklisted_process_detected`
- `process_blacklist`
