# CEDAR C++ SDK Security Guidance

## Threat model

The client can be inspected by attackers. Treat client-side checks as telemetry and friction, not absolute trust anchors.

## Implemented controls in this SDK example

- Per-request signing for SDK sensitive calls (`X-Cedar-Signature`, HMAC-SHA256).
- Nonce + timestamp transport fields for anti-replay alignment with backend policy.
- Secure token lifecycle in-memory (`SessionState`).
- `SecureString` with explicit memory wipe on destruction.
- Optional TLS pinned public key (`CURLOPT_PINNEDPUBLICKEY`).
- Optional backend signing key pin (`expected_server_signing_key_b64`).
- Clock skew guard on sdk init (`server_time` vs local clock).
- HWID helper with deterministic machine fingerprint source hashing.
- AES-256-GCM helpers for runtime encrypted blobs.
- Debugger presence check.
- VM heuristic checks.
- Process blacklist scanning (Linux `/proc` implementation).
- Local binary hash helper for integrity comparison.
- Local policy gate before entitlement activation:
  - block on debugger
  - block on VM
  - block on blacklisted process

## Practical recommendations

- Rotate `app_secret` regularly.
- Do not trust client telemetry alone; enforce policy server-side.
- Enforce strict app settings in admin panel (replay windows, lockouts, anomaly handling).
- Require periodic `check()` heartbeats from client.
- Revoke sessions/licenses from backend when risk signals increase.

## Deliberately excluded

This example does not include offensive evasion features (stealth/injection/thread hiding). It focuses on defensive integrity and policy enforcement compatibility.
