# CEDAR SDK Security Guide

## Defensive controls provided

- TLS verification and optional TLS public-key pinning.
- Signed SDK requests (`X-Cedar-Nonce`, `X-Cedar-Timestamp`, `X-Cedar-Signature`).
- Server clock skew validation.
- Entitlement signature verification (Ed25519).
- Optional server signing-key pinning.
- Optional local process/VM/debugger gates.
- Response schema validation for critical auth/license operations.
- Session/auth TTL minimum policy enforcement.
- Activation confirmation roundtrip (`activate` + `validate`) when enabled.
- Sensitive in-memory secret/token wiping in destructor.
- Auth telemetry enrichment on `login`/`regstr` for server-side risk analytics.
- Device hardware telemetry on `license` activation for device intelligence and audit trails.

## Recommended production settings

- `verify_tls = true`
- `policy.require_https = true`
- `policy.allow_localhost_http = false`
- `policy.verify_entitlement_signature = true`
- `policy.require_activation_validate_roundtrip = true`
- `policy.require_subscription_not_expired = true`
- `policy.min_session_ttl_secs >= 120`
- `policy.min_auth_ttl_secs >= 120`
- configure `policy.expected_server_signing_key_b64`
- `policy.require_pinned_server_signing_key = true`
- rotate app secrets regularly

## Application credential handling

- Prefer `load_profile_from_env(\"CEDAR\")` in production deployment pipelines.
- For embedded distribution, store encrypted profile JSON and load with `load_profile_from_encrypted_blob(...)`.
- Profile JSON fields expected by encrypted loader:
  - `app_name`
  - `owner_id`
  - `app_secret`
  - `version`
  - `base_url`

## Threat model note

Client-side controls increase cost for attackers but do not replace server-side enforcement.
Keep final policy, access decisions, and revocation authoritative on backend.
