#pragma once

#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct cedar_sdk_handle cedar_sdk_handle;

cedar_sdk_handle* cedar_sdk_create(const char* app_name,
                                   const char* owner_id,
                                   const char* app_secret,
                                   const char* version,
                                   const char* base_url,
                                   int verify_tls);
void cedar_sdk_destroy(cedar_sdk_handle* handle);

int cedar_sdk_init(cedar_sdk_handle* handle);
int cedar_sdk_preflight(cedar_sdk_handle* handle);
int cedar_sdk_login(cedar_sdk_handle* handle, const char* username, const char* password);
int cedar_sdk_regstr(cedar_sdk_handle* handle,
                     const char* username,
                     const char* password,
                     const char* license_key);
int cedar_sdk_license(cedar_sdk_handle* handle, const char* license_key);
int cedar_sdk_deactivate(cedar_sdk_handle* handle);
int cedar_sdk_check(cedar_sdk_handle* handle);
int cedar_sdk_ban(cedar_sdk_handle* handle, const char* reason);
int cedar_sdk_log(cedar_sdk_handle* handle, const char* message);
int cedar_sdk_setvar(cedar_sdk_handle* handle, const char* name, const char* value);
const char* cedar_sdk_getvar(cedar_sdk_handle* handle, const char* name);
int cedar_sdk_download(cedar_sdk_handle* handle, const char* file_id_or_path, const char* output_file);
int cedar_sdk_logout(cedar_sdk_handle* handle);
int cedar_sdk_fetch_public_announcements(cedar_sdk_handle* handle);
int cedar_sdk_fetch_sdk_announcements(cedar_sdk_handle* handle);
int cedar_sdk_fetch_public_motd(cedar_sdk_handle* handle);
int cedar_sdk_fetch_sdk_motd(cedar_sdk_handle* handle);
int cedar_sdk_fetch_public_status(cedar_sdk_handle* handle);
int cedar_sdk_current_session_valid(cedar_sdk_handle* handle);
int cedar_sdk_verify_subscription_active(cedar_sdk_handle* handle);
int cedar_sdk_custom_call(cedar_sdk_handle* handle,
                          const char* method,
                          const char* path_or_url,
                          const char* json_body,
                          int use_auth_token,
                          int use_sdk_token,
                          int sign_request);
void cedar_sdk_set_endpoint(cedar_sdk_handle* handle, const char* name, const char* path);
void cedar_sdk_set_security_policy(cedar_sdk_handle* handle,
                                   int require_https,
                                   int allow_localhost_http,
                                   long max_clock_skew_secs);
void cedar_sdk_set_signing_key_pin(cedar_sdk_handle* handle,
                                   const char* expected_key_b64,
                                   int require_pin);
void cedar_sdk_set_local_guards(cedar_sdk_handle* handle,
                                int block_debugger,
                                int block_vm,
                                int block_blacklist);
int cedar_sdk_load_profile_from_env(cedar_sdk_handle* handle, const char* env_prefix);
int cedar_sdk_load_profile_from_encrypted_blob(cedar_sdk_handle* handle,
                                               const char* profile_blob_b64,
                                               const char* decrypt_secret);

const char* cedar_sdk_last_message(cedar_sdk_handle* handle);
long cedar_sdk_last_http_code(cedar_sdk_handle* handle);
const char* cedar_sdk_last_raw(cedar_sdk_handle* handle);

#ifdef __cplusplus
}
#endif
