import { CedarClient } from '../src/cedar.js';

const client = new CedarClient({
  baseUrl: process.env.CEDAR_BASE_URL || 'http://localhost:21878',
  appId: process.env.CEDAR_APP_ID || 'app_replace_me',
  appSecret: process.env.CEDAR_APP_SECRET || 'replace_me',
  sdkVersion: '1.0.0',
});

(async () => {
  console.log('health', await client.health());
  console.log('login', await client.login(process.env.CEDAR_USER || 'admin', process.env.CEDAR_PASS || '1029Aztra!!'));
  console.log('auth heartbeat', await client.heartbeat());
  console.log('sdk init', await client.sdkInit('node-example-device', 'node-hwid'));
  console.log('activate', await client.activateLicense(process.env.CEDAR_LICENSE || 'LIC-REPLACE', 'node-example-device', 'node-hwid'));
  console.log('sdk heartbeat', await client.sdkHeartbeat());
  console.log('validate', await client.validateEntitlement());
})();
