# CEDAR Python SDK API Alignment

Default mapped routes:

- `POST /api/sdk/init`
- `POST /api/sdk/license/activate`
- `POST /api/sdk/license/deactivate`
- `POST /api/sdk/heartbeat`
- `GET /api/sdk/license/validate`
- `GET /api/sdk/announcements`
- `POST /api/auth/login`
- `POST /api/auth/register`
- `POST /api/auth/heartbeat`
- `POST /api/auth/logout`
- `POST /api/sdk/log`
- `POST /api/public/license-abuse-report`
- `GET /api/public/announcements`
- `GET /api/public/status`

Runtime override:

```python
sdk.set_endpoint("sdk_init", "/api/sdk/init")
```

Backend constraints reflected by SDK:

- init nonce must be >= 12 chars
- activation requires nonce >= 12
- activation requires device_id length >= 8
- login/register include optional telemetry payload:
  - `discord_tag`, `hwid`, `machine_id`, `device_uuid`, `gpu_name`, `reg_info`
  - `os_name`, `os_version`, `cpu_model`, `host_name`
- activation includes `device_profile`:
  - `os_name`, `os_version`, `cpu_model`, `cpu_cores`, `ram_mb`, `gpu_name`, `motherboard`, `host_name`
