# CEDAR Python SDK Integration Guide

```python
from cedar_sdk import CedarSDK, SecurityPolicy

sdk = CedarSDK(
    app_name="MyApp",
    owner_id="app_xxx",
    app_secret="secret_xxx",
    version="1.0.0",
    base_url="https://api.example.com",
    verify_tls=True,
)

policy = SecurityPolicy()
policy.require_https = True
policy.allow_localhost_http = False
policy.require_activation_validate_roundtrip = True
policy.require_subscription_not_expired = True
sdk.set_security_policy(policy)

if not sdk.preflight():
    raise RuntimeError(sdk.response.message)
if not sdk.init():
    raise RuntimeError(sdk.response.message)
if not sdk.license("LIC-XXXX"):
    raise RuntimeError(sdk.response.message)
if not sdk.check():
    raise RuntimeError(sdk.response.message)
```

Optional proxy/IP identity headers:

```python
sdk.set_default_headers({
    "X-Forwarded-For": "203.0.113.24",
    "X-Real-IP": "203.0.113.24",
})
```

Environment profile loading:

```python
sdk.load_profile_from_env("CEDAR")
```

Expected env vars:

- `CEDAR_APP_NAME`
- `CEDAR_OWNER_ID`
- `CEDAR_APP_SECRET`
- `CEDAR_VERSION`
- `CEDAR_BASE_URL`

Optional:

- `CEDAR_X_FORWARDED_FOR`
- `CEDAR_X_REAL_IP`
