# CEDAR Python SDK Security Guide

## Controls provided

- Signed SDK requests (nonce/timestamp/signature)
- HTTPS policy and TLS verification controls
- Clock skew checks
- Optional entitlement signature verification (`pynacl`)
- Optional server signing-key pin matching
- Optional debugger/VM local guards
- Activation + validation confirmation
- Subscription expiry enforcement
- Min token TTL checks
- Optional signed-only custom call policy
- Login/register telemetry enrichment for auth risk analytics
- Activation `device_profile` telemetry for device intelligence and audit visibility

## Recommended production policy

- `verify_tls=True`
- `require_https=True`
- `allow_localhost_http=False`
- `require_activation_validate_roundtrip=True`
- `require_subscription_not_expired=True`
- `min_session_ttl_secs>=120`
- `min_auth_ttl_secs>=120`
- set `expected_server_signing_key_b64`
- set `require_pinned_server_signing_key=True`

## App information handling

- Load from env in deployment:
  - `CEDAR_APP_NAME`
  - `CEDAR_OWNER_ID`
  - `CEDAR_APP_SECRET`
  - `CEDAR_VERSION`
  - `CEDAR_BASE_URL`
- Use `load_profile_from_env("CEDAR")`.
